/*
 * Decompiled with CFR 0.152.
 */
public class JagexSprite
extends Sprite {
    public int height;
    public int offsetY;
    public int deltaHeight;
    public int offsetX;
    public int deltaWidth;
    public int width;
    public int[] palette;
    public byte[] raster;
    public byte[] alpha;

    @Override
    public void rotateClockwise() {
        byte[] is = new byte[this.width * this.height];
        int i = 0;
        if (this.alpha == null) {
            int i_0_ = 0;
            while (i_0_ < this.width) {
                int i_1_ = this.height - 1;
                while (i_1_ >= 0) {
                    is[i++] = this.raster[i_0_ + i_1_ * this.width];
                    --i_1_;
                }
                ++i_0_;
            }
            this.raster = is;
        } else {
            byte[] is_2_ = new byte[this.width * this.height];
            int i_3_ = 0;
            while (i_3_ < this.width) {
                int i_4_ = this.height - 1;
                while (i_4_ >= 0) {
                    is[i] = this.raster[i_3_ + i_4_ * this.width];
                    is_2_[i++] = this.alpha[i_3_ + i_4_ * this.width];
                    --i_4_;
                }
                ++i_3_;
            }
            this.raster = is;
            this.alpha = is_2_;
        }
        int height = this.offsetY;
        this.offsetY = this.offsetX;
        this.offsetX = this.deltaHeight;
        this.deltaHeight = this.deltaWidth;
        this.deltaWidth = this.offsetY;
        height = this.height;
        this.height = this.width;
        this.width = height;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha != null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getScaleWidth() {
        return this.width + this.offsetX + this.deltaWidth;
    }

    @Override
    public int getScaleHeight() {
        return this.height + this.offsetY + this.deltaHeight;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public int getDeltaHeight() {
        return this.deltaHeight;
    }

    @Override
    public void clearOffsets() {
        this.deltaHeight = 0;
        this.offsetY = 0;
        this.deltaWidth = 0;
        this.offsetX = 0;
    }

    @Override
    public void flipHorizontal() {
        byte[] is = this.raster;
        if (this.alpha == null) {
            int i = this.height - 1;
            while (i >= 0) {
                int i_24_ = i * this.width;
                int i_25_ = (i + 1) * this.width;
                while (i_24_ < i_25_) {
                    byte i_26_ = is[i_24_];
                    is[i_24_] = is[--i_25_];
                    is[i_25_] = i_26_;
                    ++i_24_;
                }
                --i;
            }
        } else {
            byte[] is_27_ = this.alpha;
            int i = this.height - 1;
            while (i >= 0) {
                int i_28_ = i * this.width;
                int i_29_ = (i + 1) * this.width;
                while (i_28_ < i_29_) {
                    byte i_30_ = is[i_28_];
                    is[i_28_] = is[--i_29_];
                    is[i_29_] = i_30_;
                    i_30_ = is_27_[i_28_];
                    is_27_[i_28_] = is_27_[i_29_];
                    is_27_[i_29_] = i_30_;
                    ++i_28_;
                }
                --i;
            }
        }
        int i = this.offsetX;
        this.offsetX = this.deltaWidth;
        this.deltaWidth = i;
    }

    @Override
    public void flipVertical() {
        byte[] is = this.raster;
        if (this.alpha == null) {
            int i = (this.height >> 1) - 1;
            while (i >= 0) {
                int i_31_ = i * this.width;
                int i_32_ = (this.height - i - 1) * this.width;
                int i_33_ = -this.width;
                while (i_33_ < 0) {
                    byte i_34_ = is[i_31_];
                    is[i_31_] = is[i_32_];
                    is[i_32_] = i_34_;
                    ++i_31_;
                    ++i_32_;
                    ++i_33_;
                }
                --i;
            }
        } else {
            byte[] is_35_ = this.alpha;
            int i = (this.height >> 1) - 1;
            while (i >= 0) {
                int i_36_ = i * this.width;
                int i_37_ = (this.height - i - 1) * this.width;
                int i_38_ = -this.width;
                while (i_38_ < 0) {
                    byte i_39_ = is[i_36_];
                    is[i_36_] = is[i_37_];
                    is[i_37_] = i_39_;
                    i_39_ = is_35_[i_36_];
                    is_35_[i_36_] = is_35_[i_37_];
                    is_35_[i_37_] = i_39_;
                    ++i_36_;
                    ++i_37_;
                    ++i_38_;
                }
                --i;
            }
        }
        int i = this.offsetY;
        this.offsetY = this.deltaHeight;
        this.deltaHeight = i;
    }

    @Override
    public int getDeltaWidth() {
        return this.deltaWidth;
    }

    @Override
    public void offsetColour(int dr, int dg, int db) {
        int index = 1;
        while (index < this.palette.length) {
            if (this.palette[index] != 1 && this.palette[index] != 0xFF00FF) {
                int red = this.palette[index] >> 16 & 0xFF;
                if ((red += dr) < 0) {
                    red = 0;
                } else if (red > 255) {
                    red = 255;
                }
                int green = this.palette[index] >> 8 & 0xFF;
                if ((green += dg) < 0) {
                    green = 0;
                } else if (green > 255) {
                    green = 255;
                }
                int blue = this.palette[index] >> 0 & 0xFF;
                if ((blue += db) < 0) {
                    blue = 0;
                } else if (blue > 255) {
                    blue = 255;
                }
                this.palette[index] = red << 16 | green << 8 | blue;
            }
            ++index;
        }
    }

    @Override
    public int getColour(int x, int i_52_) {
        return this.palette[this.raster[x + i_52_ * this.width] & 0xFF];
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public void scale(int border) {
        int scaleWidth = this.getScaleWidth();
        int scaleHeight = this.getScaleHeight();
        if (this.width != scaleWidth || this.height != scaleHeight) {
            int dh;
            int dy;
            int dw;
            int dx = border;
            if (dx > this.offsetX) {
                dx = this.offsetX;
            }
            if ((dw = border) + this.offsetX + this.width > scaleWidth) {
                dw = scaleWidth - this.offsetX - this.width;
            }
            if ((dy = border) > this.offsetY) {
                dy = this.offsetY;
            }
            if ((dh = border) + this.offsetY + this.height > scaleHeight) {
                dh = scaleHeight - this.offsetY - this.height;
            }
            int width = this.width + dx + dw;
            int height = this.height + dy + dh;
            byte[] raster = new byte[width * height];
            if (this.alpha == null) {
                int y = 0;
                while (y < this.height) {
                    int source = y * this.width;
                    int dest = (y + dy) * width + dx;
                    int x = 0;
                    while (x < this.width) {
                        raster[dest++] = this.raster[source++];
                        ++x;
                    }
                    ++y;
                }
            } else {
                byte[] alpha = new byte[width * height];
                int y = 0;
                while (y < this.height) {
                    int sourceOffset = y * this.width;
                    int destOffset = (y + dy) * width + dx;
                    int x = 0;
                    while (x < this.width) {
                        alpha[destOffset] = this.alpha[sourceOffset];
                        raster[destOffset++] = this.raster[sourceOffset++];
                        ++x;
                    }
                    ++y;
                }
                this.alpha = alpha;
            }
            this.offsetX -= dx;
            this.offsetY -= dy;
            this.deltaWidth -= dw;
            this.deltaHeight -= dh;
            this.width = width;
            this.height = height;
            this.raster = raster;
        }
    }

    @Override
    public void setShadowColour(int colour) {
        int paletteIndex = -1;
        if (this.palette.length < 255) {
            int index = 0;
            while (index < this.palette.length) {
                if (this.palette[index] == colour) {
                    paletteIndex = index;
                    break;
                }
                ++index;
            }
            if (paletteIndex == -1) {
                paletteIndex = this.palette.length;
                int[] modified = new int[this.palette.length + 1];
                System.arraycopy(this.palette, 0, modified, 0, this.palette.length);
                this.palette = modified;
                modified[paletteIndex] = colour;
            }
        } else {
            int minimum = Integer.MAX_VALUE;
            int newR = colour >> 16 & 0xFF;
            int newG = colour >> 8 & 0xFF;
            int newB = colour & 0xFF;
            int index = 0;
            while (index < this.palette.length) {
                int sum;
                int db;
                int dg;
                int current = this.palette[index];
                int r = current >> 16 & 0xFF;
                int g = current >> 8 & 0xFF;
                int b = current & 0xFF;
                int dr = newR - r;
                if (dr < 0) {
                    dr = -dr;
                }
                if ((dg = newG - g) < 0) {
                    dg = -dg;
                }
                if ((db = newB - b) < 0) {
                    db = -db;
                }
                if ((sum = dr + dg + db) < minimum) {
                    minimum = sum;
                    paletteIndex = index;
                }
                ++index;
            }
        }
        int y = this.height - 1;
        while (y > 0) {
            int index = y * this.width;
            int x = this.width - 1;
            while (x > 0) {
                if (this.palette[this.raster[x + index] & 0xFF] == 0 && this.palette[this.raster[x + index - 1 - this.width] & 0xFF] != 0) {
                    this.raster[x + index] = (byte)paletteIndex;
                }
                --x;
            }
            --y;
        }
    }

    @Override
    public void setBorderColour(int colour) {
        int index;
        int paletteIndex = -1;
        if (this.palette.length < 255) {
            index = 0;
            while (index < this.palette.length) {
                if (this.palette[index] == colour) {
                    paletteIndex = index;
                    break;
                }
                ++index;
            }
            if (paletteIndex == -1) {
                int length;
                paletteIndex = length = this.palette.length;
                int[] palette = new int[length + 1];
                System.arraycopy(this.palette, 0, palette, 0, length);
                this.palette = palette;
                palette[paletteIndex] = colour;
            }
        } else {
            int minimum = Integer.MAX_VALUE;
            int newR = colour >> 16 & 0xFF;
            int newG = colour >> 8 & 0xFF;
            int newB = colour & 0xFF;
            int i = 0;
            while (i < this.palette.length) {
                int sum;
                int db;
                int dg;
                int current = this.palette[i];
                int r = current >> 16 & 0xFF;
                int g = current >> 8 & 0xFF;
                int b = current & 0xFF;
                int dr = newR - r;
                if (dr < 0) {
                    dr = -dr;
                }
                if ((dg = newG - g) < 0) {
                    dg = -dg;
                }
                if ((db = newB - b) < 0) {
                    db = -db;
                }
                if ((sum = dr + dg + db) < minimum) {
                    minimum = sum;
                    paletteIndex = i;
                }
                ++i;
            }
        }
        index = 0;
        byte[] recoloured = new byte[this.width * this.height];
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                int current = this.raster[index] & 0xFF;
                if (this.palette[current] == 0) {
                    if (x > 0 && this.palette[this.raster[index - 1] & 0xFF] != 0) {
                        current = paletteIndex;
                    } else if (y > 0 && this.palette[this.raster[index - this.width] & 0xFF] != 0) {
                        current = paletteIndex;
                    } else if (x < this.width - 1 && this.palette[this.raster[index + 1] & 0xFF] != 0) {
                        current = paletteIndex;
                    } else if (y < this.height - 1 && this.palette[this.raster[index + this.width] & 0xFF] != 0) {
                        current = paletteIndex;
                    }
                }
                recoloured[index++] = (byte)current;
                ++x;
            }
            ++y;
        }
        this.raster = recoloured;
    }

    @Override
    public int[] argb(boolean scale) {
        int[] argb;
        if (scale) {
            int scaleWidth = this.getScaleWidth();
            argb = new int[scaleWidth * this.getScaleHeight()];
            if (this.alpha != null) {
                int y = 0;
                while (y < this.height) {
                    int source = y * this.width;
                    int dest = this.offsetX + (y + this.offsetY) * scaleWidth;
                    int x = 0;
                    while (x < this.width) {
                        argb[dest++] = this.alpha[source] << 24 | this.palette[this.raster[source] & 0xFF];
                        ++source;
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < this.height) {
                    int source = y * this.width;
                    int dest = this.offsetX + (y + this.offsetY) * scaleWidth;
                    int x = 0;
                    while (x < this.width) {
                        int colour;
                        argb[dest++] = (colour = this.palette[this.raster[source++] & 0xFF]) != 0 ? 0xFF000000 | colour : 0;
                        ++x;
                    }
                    ++y;
                }
            }
        } else {
            argb = new int[this.width * this.height];
            int source = 0;
            int dest = 0;
            if (this.alpha != null) {
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        argb[dest++] = this.alpha[source] << 24 | this.palette[this.raster[source] & 0xFF];
                        ++source;
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        int colour = this.palette[this.raster[source++] & 0xFF];
                        argb[dest++] = colour != 0 ? 0xFF000000 | colour : 0;
                        ++x;
                    }
                    ++y;
                }
            }
        }
        return argb;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int[] getPallet() {
        return this.palette;
    }

    @Override
    public byte[] getAlphas() {
        return this.alpha;
    }
}

